<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FinanceCash extends Model 
{

    protected $table = 'finance_cash';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('amount', 'date', 'status', 'finance_category_id', 'created_by', 'updated_by');

    public function category()
    {
        return $this->belongsTo('App\Models\CategoryFinance', 'cat_id');
    }

}